import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {graphql, compose} from "react-apollo";
import gql from "graphql-tag";
import {Form, TextArea} from 'react-form';
import Loading from "../../../../core/Loading/Loading";
import DocumentsForm from "../../../../core/Forms/DocumentsForm/DocumentsForm";
import {rolesQuery,documentoQuery} from "../../../../api/queries";;

 class Edit extends Component {

    constructor(props) {
        super(props);

        this.state = {
            submitting: false,
            error: false,
        };
    }

	  render() {

    return (
      <div className="container" style={{marginBottom: '20px'}}>
        <h1>Modifica Documento</h1>
        <DocumentsForm
          errorMessage={"Errore durante la modifica del documento"}
          data={this.props.data}
          submitMutation={gql`
                    mutation($documento: DocumentoInput) {
                        updateDocumento(documento: $documento) {
                            id
                        }
                    }`} />
      </div>
    )
  }

}

export default compose(
    graphql(documentoQuery, {
        options:({match}) => ({variables: {id: match.params.id}}),
    })
)(Edit)

Edit.defaultProps = {};

Edit.propTypes = {};
